$(document).ready(function () {
	getSub();
	$("#btn-show").click(function () {
		getReport();
	});
	$("#btn-update").click(function () {
		updateReport();
	});

	$("#tableReport").DataTable({});
});

const getReport = () => {
	const awal = $("#start").val();
	const akhir = $("#end").val();
	const progresForm = $("#progresForm").val();
	$.ajax({
		type: "POST",
		url: "reports/getReport",
		data: {
			tglAwal: awal,
			tglAkhir: akhir,
			progresForm: progresForm,
		},
		dataType: "text",
		success: function (data) {
			//console.log(data);
			const dataParse = JSON.parse(data);
			//console.log(dataParse.length);
			var table = $("#tableReport").dataTable();
			table.fnClearTable();
			table.fnDraw();
			table.fnDestroy();
			let row = "";
			$.each(dataParse, function (id, val) {
				//console.log(val.linkReview);
				row += `<tr onclick="detail(${val.id_cust})">
                <td>${id + 1}</td>
                <td>${val.agentName}</td>
                <td>${val.customerName}</td>
                <td>${val.tglLapor}</td>
                <td>${val.indate}</td>
                <td>${val.bintang}</td>
                <td>${val.keluhan}</td>
                <td>${val.namaklasifikasi}</td>
                <td>${
									val.sub_klasifikasi === null ? "" : val.sub_klasifikasi
								}</td>
                <td>${val.linkReview}</td>
                <td>${val.telp === null ? "" : val.telp}</td>
                <td>${val.email === null ? "" : val.email}</td>
                <td>${val.idpel === null ? "" : val.idpel}</td>
				<td>${val.infoTambahan === null ? "" : val.infoTambahan}</td>
				<td>${val.link}</td>
                <td>${val.followUpBy === null ? "" : val.followUpBy}</td>
				<td>${val.hasilFu === null ? "" : val.hasilFu}</td>
				<td>${
					val.suspect === null ? "" : val.suspect == 1 ? "Valid" : "Tidak Valid"
				}</td>
				<td>${val.noTicket === null ? "" : val.noTicket}</td>
				<td>${val.status === null ? "" : val.status === 0 ? "Open" : "Close"}</td>
				<td>${val.keterangan === null ? "" : val.keterangan}</td>
				<td>${val.closeBy === null ? "" : val.closeBy}</td>
                <td>${val.dateBalas === null ? "" : val.dateBalas}</td>
                <td>${val.ratingUpdate === null ? "" : val.ratingUpdate}</td>
                <td>${val.review_update === null ? "" : val.review_update}</td>
                <td>${
									val.agent_cbc_update === null ? "" : val.agent_cbc_update
								}</td>
                <td>${
									val.keterangan_not_update === null
										? ""
										: val.keterangan_not_update
								}</td>
            </tr>`;
			});
			$("#tableReport > tbody").append(row);

			table.DataTable({
				columnDefs: [
					{ width: "5px", targets: 0 },
					{ width: "300px", targets: 6 },
				],
				scrollX: true,
				scrollCollapse: true,
				fixedColumns: true,
				dom: "Bfrtip",
				buttons: [
					{
						extend: "copyHtml5",
						className: "btn btn-light btn-sm",
					},
					{
						extend: "excelHtml5",
						className: "btn btn-light btn-sm",
					},
					{
						extend: "csvHtml5",
						className: "btn btn-light btn-sm",
					},
					{
						extend: "pdfHtml5",
						className: "btn btn-light btn-sm",
					},
				],
			});
		},
		error: function (xhr, status, error) {
			console.log("error");
		},
		statusCode: {
			404: function () {
				alert("page not found");
			},
		},
	});
};

const detail = (id) => {
	$("#fuBy").empty();
	$("#fuBy").append(`<option>Select Agent</option>
			<option value="Elis Nawati">Elis Nawati</option>
			<option value="Lydia Anggraini">Lydia Anggraini</option>
			<option value="Puji Lestari Rahayu">Puji Lestari Rahayu</option>
			<option value="Rahajeng Wahyuningsih">Rahajeng Wahyuningsih</option>
			<option value="Sumirah">Sumirah</option>
			<option value="Sumyani">Sumyani</option>
			<option value="Nike Kusuma Dewi">Nike Kusuma Dewi</option>
			<option value="Syahla Siswayani Permana">Syahla Siswayani Permana</option>
			<option value="Ira Dwi Nursintha">Ira Dwi Nursintha</option>
			<option value="Wenny Asmilia">Wenny Asmilia</option>
			<option value="Jorgie Samuel Runtuthomas">Jorgie Samuel Runtuthomas</option>
			<option value="Muhammad Rivaldi">Muhammad Rivaldi</option>
			<option value="Ridwan Nur Cahyo">Ridwan Nur Cahyo</option>
			<option value="Dyan Syaida Varista">Dyan Syaida Varista</option>
			<option value="Fetty Hindaryani">Fetty Hindaryani</option>
			<option value="Aisyah Rahmadhani">Aisyah Rahmadhani</option>
			<option value="Dani Rahmat Setiawan">Dani Rahmat Setiawan</option>`);
	$("#formDetail")[0].reset();
	$('input[name="bintang"]').attr("checked", false);
	$(".agentSosmed").attr("readonly", false);
	$(".cbc").attr("readonly", false);
	$("#btn-update").prop("disabled", false);
	$(".updateClose").attr("hidden", true);
	$(".finalClosing").attr("readonly", false);
	$.ajax({
		type: "POST",
		url: "reports/getDetail",
		data: {
			id,
		},
		dataType: "json",
		success: function (data) {
			$("#imgDataPendukung").removeAttr("src");
			$("#divDataPendukung").attr("hidden", true);
			//console.log(data);
			let arrayAgent = [
				"Elis Nawati",
				"Lydia Anggraini",
				"Puji Lestari Rahayu",
				"Rahajeng Wahyuningsih",
				"Sumirah",
				"Sumyani",
				"Nike Kusuma Dewi",
				"Syahla Siswayani Permana",
				"Ira Dwi Nursintha",
				"Wenny Asmilia",
				"Jorgie Samuel Runtuthomas",
				"Muhammad Rivaldi",
				"Ridwan Nur Cahyo",
				"Dyan Syaida Varista",
				"Fetty Hindaryani",
				"Aisyah Rahmadhani",
				"Dani Rahmat Setiawan",
			];
			$("#agent").val(data[0].agentName);
			$("#id_cust").val(data[0].idCust);
			$("#nama").val(data[0].customerName);
			$("#tanggal").val(data[0].tglLapor);
			$(`input[name=bintang][value=${data[0].bintang}]`).attr("checked", true);
			$("#keluhan").val(data[0].keluhan);
			$("#keterangan").val(data[0].keterangan);
			$("#infoTambahan").val(data[0].infoTambahan);
			$("#linkReview").val(data[0].linkReview);
			$("#klasifikasi")
				.val(data[0].klasifikasi)
				.find(`option[value=" ${data[0].klasifikasi} "]`)
				.attr("selected", true);
			$("#subKlasifikasi")
				.val(data[0].subKlasifikasi)
				.find(`option[value=" ${data[0].subKlasifikasi} "]`)
				.attr("selected", true);
			$("#telp").val(data[0].telp);
			$("#email").val(data[0].email);
			console.log(data[0].dataPendukung);
			if (data[0].dataPendukung) {
				$("#imgDataPendukung").attr(
					"src",
					`./assets/images/dataPendukung/${data[0].dataPendukung}`
				);
				$("#divDataPendukung").removeAttr("hidden");
			}

			if (arrayAgent.includes(data[0].followUpBy)) {
				$("#fuBy")
					.val(data[0].followUpBy)
					.find(`option[value=" ${data[0].followUpBy} "]`)
					.attr("selected", true);
			} else if (data[0].followUpBy !== null) {
				$("#fuBy").append(
					`<option value="${data[0].followUpBy}">${data[0].followUpBy}</option>`
				);
				$("#fuBy")
					.val(data[0].followUpBy)
					.find(`option[value=" ${data[0].followUpBy} "]`)
					.attr("selected", true);
			}
			$("#closeBy").val(data[0].closeBy);
			$("#ticket").val(data[0].noTicket);
			$("#link").val(data[0].link);
			$("#hasilFu")
				.val(data[0].flag)
				.find(`option[value=" ${data[0].flag} "]`)
				.attr("selected", true);
			$("#suspect")
				.val(data[0].suspect)
				.find(`option[value=" ${data[0].suspect} "]`)
				.attr("selected", true);
			$("#status")
				.val(data[0].status)
				.find(`option[value=" ${data[0].status} "]`)
				.attr("selected", true);
			$("#ratingUpdate")
				.val(data[0].rating_update == null ? 0 : data[0].rating_update)
				.find(
					`option[value=" ${
						data[0].rating_update == null ? 0 : data[0].rating_update
					} "]`
				)
				.attr("selected", true);
			$("#reviewUpdate").val(data[0].review_update);
			$("#agentCbcUpdate").val(data[0].agent_cbc_update);
			$("#keteranganTidakUpdate").val(data[0].keterangan_not_update);

			$(":radio:not(:checked)").attr("disabled", true);
			//$(`radio[name='bintang']`).attr("disabled", "disabled");
			$("#klasifikasi option:not(:selected)").attr("disabled", "disabled");
			$("#subKlasifikasi option:not(:selected)").attr("disabled", "disabled");
			if (data[0].idCust === null || data[0].status == 1) {
				if (data[0].rating_update != null && data[0].review_update != null) {
					$(".updateClose").attr("hidden", false);
					$(".agentSosmed").attr("readonly", true);
					$(".finalClosing").attr("readonly", true);
					$("#btn-update").prop("disabled", true);
				} else {
					$(".agentSosmed").attr("readonly", true);
					$(".cbc").attr("readonly", true);
					$(".updateClose").attr("hidden", false);
				}
			}
			let arrayFlag = ["4", "8", "9", "11"];
			if (data[0].followUpBy === null || arrayFlag.includes(data[0].flag)) {
				$(".agentSosmed").attr("readonly", true);
			} else {
				$(".cbc").attr("readonly", true);
			}

			$("#modalDetail").modal("show");
		},
		error: function (xhr, status, error) {
			console.log("error");
		},
		statusCode: {
			404: function () {
				alert("page not found");
			},
		},
	});
};

const updateReport = () => {
	const fuBy = $("#fuBy").val();
	const hasilFu = $("#hasilFu").val();
	const idCust = $("#id_cust").val();
	const ticket = $("#ticket").val();
	const closeBy = $("#closeBy").val();
	const suspect = $("#suspect").val();
	const status = $("#status").val();
	const keterangan = $("#keterangan").val();
	const ratingUpdate = $("#ratingUpdate").val();
	const reviewUpdate = $("#reviewUpdate").val();
	const agentCbcUpdate = $("#agentCbcUpdate").val();
	const keteranganTidakUpdate = $("#keteranganTidakUpdate").val();
	$.ajax({
		type: "POST",
		url: "reports/updateReport",
		data: {
			fuBy,
			hasilFu,
			idCust,
			ticket,
			status,
			closeBy,
			suspect,
			keterangan,
			ratingUpdate,
			reviewUpdate,
			agentCbcUpdate,
			keteranganTidakUpdate,
		},
		dataType: "text",
		success: function (data) {
			$("#modalDetail").modal("hide");
			getReport();
		},
		error: function (xhr, status, error) {
			console.log("error");
		},
		statusCode: {
			404: function () {
				alert("page not found");
			},
		},
	});
};

const getSub = () => {
	$.ajax({
		type: "post", // Method pengiriman data bisa dengan GET atau POST
		url: "reports/getSubKlasifikasi", // Isi dengan url/path file php yang dituju
		timeout: 30000,
		success: function (response) {
			$("#subKlasifikasi").prop("disabled", false);
			var dataSub = JSON.parse(response);
			//console.log(response);
			var temp = $("#subKlasifikasi"); // cache it
			temp.empty();
			var option = "";
			$.each(dataSub, function (i, data) {
				// bind the dropdown list using json result
				option +=
					"<option value=" + data.id + ">" + data.sub_klasifikasi + "</option>";
			});
			$("#subKlasifikasi").trigger("chosen:updated");
			$("#subKlasifikasi").append(option);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			// Ketika ada error
			if (ajaxOptions === "timeout") {
				alert("Req timeout : Insert pelanggan");
			} else {
				alert(ajaxOptions);
			}
		},
	});
};

function ConvertMinutes(num) {
	d = Math.floor(num / 1440); // 60*24
	h = Math.floor((num - d * 1440) / 60);
	m = Math.round(num % 60);
	s = "00";

	if (d > 0) {
		return d + "D " + h + ":" + m + ":" + s;
	} else {
		return h + ":" + m + ":" + s;
	}
}
