$(document).ready(function () {
	$("#btnGenerate").click(function () {
		generate();
		$("#btnGenerate").prop("disabled", true);
	});

	$("#btnClear").click(function () {
		$(".form-control").val("");
		$("#btnGenerate").prop("disabled", false);
	});

	$("#btnCopy").click(function () {
		copyToClipboard();
	});
});
function copyToClipboard() {
	var textBox = document.getElementById("formGenerate");
	textBox.select();
	document.execCommand("copy");
}
function generate() {
	let nama = $("#nama").val();
	let tanggal = $("#tanggal").val();
	let keluhan = $("#keluhan").val();
	let agentName = $("#agent").val();
	let jam = $("#jam").val();
	let bintang = $('input[name="bintang"]:checked').val();
	let linkReview = $("#linkReview").val();
	let klasifikasi = $("#klasifikasi").val();
	let subKlasifikasi = $("#subKlasifikasi").val();
	//let longUrl = `http://localhost/form/?nama=${nama}&tanggal=${tanggal}&keluhan=${keluhan}`;
	//dataPost={nama,tanggal,keluhan,agentName};
	// $.post('http://localhost:4000/api/form', { url: longUrl }).done(function (data) {
	//     console.log(data);
	// });
	if (tanggal == "" || klasifikasi == null || subKlasifikasi == "null" || bintang == undefined || jam =='') {
		alert("Anda harus mengisi data dengan lengkap!");
	} else {
		jQuery.ajax({
			url: "generate",
			type: "POST",
			data: {
				nama: nama,
				tanggal: tanggal,
				keluhan: keluhan,
				agentName: agentName,
				bintang: bintang,
				linkReview: linkReview,
				klasifikasi: klasifikasi,
				subKlasifikasi: subKlasifikasi,
				jam:jam
			},
			dataType: "json",
			success: function (data) {
				$("#formGenerate").val(data);
			},
		});
	}
}

$("#klasifikasi").on("change", function () {
	var xx = $("#klasifikasi").find("option:selected").val();
	getSub(xx);
});

const getSub = ($klasifikasi) => {
	$.ajax({
		type: "post", // Method pengiriman data bisa dengan GET atau POST
		url: "getSubKlasifikasi", // Isi dengan url/path file php yang dituju
		data: { klasifikasi: $klasifikasi },
		timeout: 30000,
		success: function (response) {
			$("#subKlasifikasi").prop("disabled", false);
			var data = JSON.parse(response);
			//console.log(response);
			var temp = $("#subKlasifikasi"); // cache it
			temp.empty();
			$("#subKlasifikasi").append(
				"<option value=''>Select Sub Klasifikasi</option>"
			);
			var option = "";
			$.each(data, function (i, data) {
				// bind the dropdown list using json result
				option +=
					"<option value=" + data.id + ">" + data.sub_klasifikasi + "</option>";
			});
			$("#subKlasifikasi").trigger("chosen:updated");
			$("#subKlasifikasi").append(option);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			// Ketika ada error
			if (ajaxOptions === "timeout") {
				alert("Req timeout : Insert pelanggan");
			} else {
				alert(ajaxOptions);
			}
		},
	});
};
