<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Report_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function getReport($tgl1, $tgl2, $progresForm)
    {
        $q = "SELECT   A.*, 
              B.id id_cust,
              B.email,
              B.infoTambahan,
              B.dataPendukung,
              B.flag,
              B.followUpBy, 
              B.idAgentReview, 
              B.noTicket,
              B.telp,
              B.idpel,
              B.closeBy,
              B.status,
              B.suspect,
              B.keterangan,
              B.indate dateBalas, B.rating_update,B.`review_update`,B.`agent_cbc_update`,B.`keterangan_not_update`,
              C.klasifikasi namaklasifikasi, 
              D.status hasilFu, 
              E.sub_klasifikasi,
              F.rating ratingUpdate,
              TIMESTAMPDIFF(SECOND,A.tglLapor,A.indate) durasiagent,
              TIMESTAMPDIFF(SECOND,A.indate,B.indate) durasilapor
                    FROM agentReview A 
                    LEFT JOIN custReview B ON A.id=B.idAgentReview
                    LEFT JOIN klasifikasi C ON A.klasifikasi=C.id
                    LEFT JOIN t_custStatus D ON B.flag=D.id 
                    LEFT JOIN t_sub_klasifikasi E ON A.subKlasifikasi=E.id
                    LEFT JOIN rating_update F ON B.rating_update=F.id
        WHERE A.indate BETWEEN '" . $tgl1 . " 00:00:00' AND '" . $tgl2 . " 23:59:59' AND (B.deleted='0' OR B.deleted IS NULL) " . $progresForm . "  ORDER BY A.indate DESC";
        $query = $this->db->query($q);
        return $query->result();
    }

    public function getDetailReport($id)
    {
        $q = "SELECT A.*, B.id idCust,B.`email`,B.`infoTambahan`,B.`dataPendukung`,B.`flag`,B.`followUpBy`, B.`idAgentReview`, B.`noTicket`,B.`telp`,B.`closeBy`, B.`status`,B.`suspect`,B.`keterangan`,B.`rating_update`,B.`review_update`,B.`agent_cbc_update`,B.`keterangan_not_update`
        FROM agentReview A LEFT JOIN custReview B ON A.`id`=B.`idAgentReview`
        WHERE B.id='" . $id . "'";
        $query = $this->db->query($q);
        return $query->result();
    }

    public function insert($data)
    {
        $this->db->insert('custReview', $data);
    }

    //edit
    public function updateReport($data)
    {
        $this->db->where('id', $data['id']);
        $this->db->update('custReview', $data);
    }

    public function getSubKlasifikasi()
    {
        $q = "SELECT * FROM t_sub_klasifikasi  where status='1'";
        $query = $this->db->query($q);
        return $query->result();
    }
}

/* End of file Berita_model.php */
/* Location: ./application/models/Berita_model.php */