<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Reports extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('report_model');
    }


    public function index()
    {
        $this->load->view('report');
    }

    public function getReport()
    {
        $awal = $this->input->post('tglAwal');
        $akhir = $this->input->post('tglAkhir');
        $progresForm = $this->input->post('progresForm');
        switch ($progresForm) {
            case 2:
                $params = "and A.flag IS NULL";
                break;
            case 3:
                $params = "and A.`flag`='1' and B.`followUpBy` IS NULL";
                break;
            case 4:
                $params = "and A.`flag`='1' and B.`followUpBy` IS NOT NULL and B.`status` IS NULL";
                break;
            case 5:
                $params = "and A.`flag`='1' and B.`followUpBy` IS NOT NULL and B.`status` ='1'";
                break;
            default:
                $params = '';
        }
        $resData = $this->report_model->getReport($awal, $akhir, $params);
        echo json_encode($resData);
    }

    public function getDetail()
    {
        $id = $this->input->post('id');
        $resData = $this->report_model->getDetailReport($id);
        echo json_encode($resData);
    }

    public function updateReport()
    {
        $status = $this->input->post('status');
        $ratingUpdate = $this->input->post('ratingUpdate');
        $reviwUpdate = $this->input->post('reviewUpdate');
        $agentCbcUpdate = $this->input->post('agentCbcUpdate');
        $keteranganTidakUpdate = $this->input->post('keteranganTidakUpdate');

        if ($status == 1) {
            if ($ratingUpdate == '0' &&  $agentCbcUpdate == '' && $reviwUpdate == '') {
                $dataUpdate = array(
                    'id'         => $this->input->post('idCust'),
                    'closeBy'    => $this->input->post('closeBy'),
                    'status'     => $this->input->post('status'),
                    'keterangan' => $this->input->post('keterangan'),
                    'closeDate'  => date('Y-m-d H:i:s'),
                );
            } else {
                $dataUpdate = array(
                    'id'         => $this->input->post('idCust'),
                    'rating_update'         => $ratingUpdate,
                    'review_update'     => $reviwUpdate,
                    'agent_cbc_update' => $agentCbcUpdate,
                    'keterangan_not_update' => $keteranganTidakUpdate
                );
            }
        } else {
            $dataUpdate = array(
                'id'         => $this->input->post('idCust'),
                'flag'       => $this->input->post('hasilFu'),
                'followUpBy' => $this->input->post('fuBy'),
                'noTicket'   => $this->input->post('ticket'),
                'suspect'   => $this->input->post('suspect'),
                'dateFu' => date('Y-m-d H:i:s'),
            );
        }
        $resData = $this->report_model->updateReport($dataUpdate);
        echo json_encode($resData);
    }

    public function getSubKlasifikasi()
    {
        $list = $this->report_model->getSubKlasifikasi();
        echo json_encode($list);
    }
}
