<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Form extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('form_model');
		$this->load->library('upload');
    }


    public function index()
    {
        show_404();
    }

    public function agent()
    {
        $this->load->view('formAgent');
    }

    public function detail($id)
    {
        $resData     = $this->form_model->detail($id);
        if (count($resData) > 0) {

            $data = array(
                'resData'        => $resData[0]
            );
            $this->load->view('formPost', $data, FALSE);
        } else {
            show_404();
        };
    }

    public function generate()
    {
        $idForm = time();
        $link = $this->get_tiny_url(base_url('form/detail/') . $idForm);

        $dataInput = array(
            'idForm'            => $idForm,
            'agentName'         => $this->input->post('agentName'),
            'customerName'      => $this->input->post('nama'),
            'tglLapor'          => $this->input->post('tanggal').' '.$this->input->post('jam'),
            'keluhan'           => $this->input->post('keluhan'),
            'bintang'           => $this->input->post('bintang'),
            'linkReview'        => $this->input->post('linkReview'),
            'klasifikasi'       => $this->input->post('klasifikasi'),
            'subklasifikasi'    => $this->input->post('subKlasifikasi'),
            'link'              => $link,
        );
        $this->form_model->insertAgent($dataInput);
        echo json_encode($link);
    }

    public function formPost($id)
    {
        $valid = $this->form_validation;

        $valid->set_rules(
            'hp',
            'Hp',
            'required',
            array('required'        => '%s harus diisi')
        );
        $valid->set_rules(
            'idpel',
            'ID Pelanggan PLN',
            'required',
            array('required'        => '%s harus diisi')
        );
        if ($valid->run() === FALSE) {
            $this->session->set_flashdata('flashError', 'Telepon & ID Pelanggan PLN Harus diisi');
            redirect(base_url('form/detail/') . $id, 'refresh');
        } else {
            $recaptchaResponse = trim($this->input->post('g-recaptcha-response'));

            $userIp = $this->input->ip_address();

            $secret = $this->config->item('google_secret');

            $url = "https://www.google.com/recaptcha/api/siteverify?secret=" . $secret . "&response=" . $recaptchaResponse . "&remoteip=" . $userIp;

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $output = curl_exec($ch);
            curl_close($ch);

            $status = json_decode($output, true);

            if ($status['success']) {
				
				$config['upload_path'] = './assets/images/dataPendukung/'; //path folder
				$config['max_size'] = '5000'; // max_size in kb
				$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp'; //type yang dapat diakses bisa anda sesuaikan
				$config['encrypt_name'] = TRUE; //Enkripsi nama yang terupload
		 
				$this->upload->initialize($config);
				if(!empty($_FILES['dataPendukung']['name'])){
		 
					if ($this->upload->do_upload('dataPendukung')){
						$gbr = $this->upload->data();
						//Compress Image
						$config['image_library']='gd2';
						$config['source_image']='./assets/images/dataPendukung/'.$gbr['file_name'];
						$config['create_thumb']= FALSE;
						$config['maintain_ratio']= FALSE;
						$config['quality']= '50%';
						$config['width']= 600;
						$config['height']= 400;
						$config['new_image']= './assets/images/dataPendukung/'.$gbr['file_name'];
						$this->load->library('image_lib', $config);
						$this->image_lib->resize();
		 
						$gambar=$gbr['file_name'];
						$idAgentReview     = $this->input->post('idAgentReview');
						$telp              = $this->input->post('hp');
						$idpel             = $this->input->post('idpel');
						//$email             = $this->input->post('email');
						//$infoTambahan      = $this->input->post('infoTambahan');
						$this->form_model->insertProc($idAgentReview, $telp, $idpel, $gambar);
					}
							  
				}else{
					$idAgentReview     = $this->input->post('idAgentReview');
                    $telp              = $this->input->post('hp');
                    $idpel             = $this->input->post('idpel');
                    //$email             = $this->input->post('email');
					//$infoTambahan      = $this->input->post('infoTambahan');
					$this->form_model->insertProc($idAgentReview, $telp, $idpel,'');
				}
				
                    

                $this->session->set_flashdata('flashSukses', '😊 Terima Kasih 😊 Pelanggan yang terhormat, saat ini untuk Informasi Tagihan Listrik, Keluhan dan Gangguan Kelistrikan, Layanan Pasang Baru, Ubah Daya dan Penyambungan Sementara dapat diakses juga melalui Aplikasi New PLN Mobile agar Semua Makin Mudah');
            } else {
                $this->session->set_flashdata('flashError', 'Mohon maaf captcha harus diisi!!');
            }

            redirect(base_url('form/detail/') . $id, 'refresh');
        }
    }

    private function get_tiny_url($url)
    {
        $ch = curl_init();
        $timeout = 5;
        curl_setopt($ch, CURLOPT_URL, 'http://tinyurl.com/api-create.php?url=' . $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        $data = curl_exec($ch);
        curl_close($ch);
        return $data;
    }

    public function getSubKlasifikasi()
    {
        $sub = $this->input->post('klasifikasi');
        $list = $this->form_model->getSubKlasifikasi($sub);
        echo json_encode($list);
    }
}
